/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.datagen.recipe.builder.AbstractRecipeBuilder;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class CentrifugeRecipeBuilder
extends AbstractRecipeBuilder {
    private final Ingredient input;
    private final List<AbstractRecipeBuilder.IngredientOutput> output;
    private AbstractRecipeBuilder.FluidOutput fluid;
    private final List<ICondition> conditions;
    private boolean isConfigurable = false;

    private CentrifugeRecipeBuilder(Ingredient input, List<AbstractRecipeBuilder.IngredientOutput> output, AbstractRecipeBuilder.FluidOutput fluid, List<ICondition> conditions, boolean isConfigurable) {
        this.input = input;
        this.output = output;
        this.fluid = fluid;
        this.conditions = conditions;
        this.isConfigurable = isConfigurable;
    }

    public static CentrifugeRecipeBuilder item(Item item) {
        return new CentrifugeRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), new ArrayList<AbstractRecipeBuilder.IngredientOutput>(), null, new ArrayList<ICondition>(), false);
    }

    public static CentrifugeRecipeBuilder configurable(String beeName, List<AbstractRecipeBuilder.IngredientOutput> output, AbstractRecipeBuilder.FluidOutput fluid, List<ICondition> conditions) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
        BeeCreator.setTag("productivebees:" + beeName, stack);
        if (output.isEmpty()) {
            output.add(new AbstractRecipeBuilder.IngredientOutput(Ingredient.m_204132_(ModTags.Forge.WAX)));
        }
        if (fluid != null) {
            fluid = new AbstractRecipeBuilder.FluidOutput("productivebees:honey");
        }
        return new CentrifugeRecipeBuilder((Ingredient)NBTIngredient.of((ItemStack)stack), output, fluid, conditions, true);
    }

    public static CentrifugeRecipeBuilder configurable(String beeName) {
        return CentrifugeRecipeBuilder.configurable(beeName, new ArrayList<AbstractRecipeBuilder.IngredientOutput>(), null, new ArrayList<ICondition>());
    }

    public CentrifugeRecipeBuilder addOutput(AbstractRecipeBuilder.IngredientOutput output) {
        this.output.add(output);
        return this;
    }

    public CentrifugeRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public CentrifugeRecipeBuilder setFluidOutput(AbstractRecipeBuilder.FluidOutput output) {
        this.fluid = output;
        return this;
    }

    public RecipeBuilder m_142284_(String criteria, CriterionTriggerInstance trigger) {
        return null;
    }

    public RecipeBuilder m_142409_(@Nullable String groupName) {
        return null;
    }

    public Item m_142372_() {
        return null;
    }

    public void m_142700_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.input, this.output, this.fluid, this.conditions));
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private List<AbstractRecipeBuilder.IngredientOutput> output;
        private AbstractRecipeBuilder.FluidOutput fluid;
        private List<ICondition> conditions;

        public Result(ResourceLocation id, Ingredient input, List<AbstractRecipeBuilder.IngredientOutput> output, AbstractRecipeBuilder.FluidOutput fluid, List<ICondition> conditions) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.fluid = fluid;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.input.m_43942_());
            JsonArray jsonarray = new JsonArray();
            for (AbstractRecipeBuilder.IngredientOutput ingredient : this.output) {
                jsonarray.add(ingredient.toJson());
            }
            if (this.fluid != null) {
                jsonarray.add(this.fluid.toJson());
            }
            json.add("outputs", (JsonElement)jsonarray);
            if (this.conditions.size() > 0) {
                JsonArray cJson = new JsonArray();
                this.conditions.forEach(condition -> cJson.add((JsonElement)CraftingHelper.serialize((ICondition)condition)));
                json.add("conditions", (JsonElement)cJson);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeTypes.CENTRIFUGE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

